import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.ManifestHeader import ManifestHeader
from cse_image_items.ManifestExtension import ManifestExtensionFactory


logger = logging.getLogger(__name__)


class Manifest(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START Manifest.__init__ FUNCTION')

        super(Manifest, self).__init__(data, **kwargs)
        self.header = ManifestHeader(self.value)
        self.set_extentions()

    def set_extentions(self):
        self.extentions = []
        start_offset = self.header.size
        while True:
            extention = ManifestExtensionFactory.create(
                value=self.value,
                offset=start_offset,
            )
            self.extentions.append(extention)
            if extention.size == 0:
                break
            start_offset += extention.size
            if start_offset >= len(self.value):
                break
